<?php

/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
get_header();
?>
<main>
	<div class="wrapper_main">
		<div class="container">
			<div class="wrapper_content">
				<div class="title_wrapper title_wrapper_2">
					<?php get_template_part('template-parts/back', 'button') ?>
				</div>
				<div class="wrapper_inner">
					<div class="content_box">
						<?php while (have_posts()) : ?>
							<?php the_post(); ?>

							<?php wc_get_template_part('content', 'single-product'); ?>

						<?php endwhile; ?>

						<?php get_template_part('template-parts/member', 'card') ?>
					</div>
					<?php get_sidebar() ?>
				</div>
			</div>
		</div>
	</div>
</main>

<?php get_footer() ?>